<?php

namespace Noptin\Addons_Pack\Users\Triggers;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Fired when a WordPress user is updated.
 *
 * @since 1.9.0
 */
class Update_User extends New_User {

	/**
	 * Constructor.
	 *
	 * @since 1.9.0
	 * @return string
	 */
	public function __construct() {
		add_action( 'profile_update', array( $this, 'maybe_trigger' ) );
	}

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'update_user';
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return __( 'User > Update Profile', 'noptin-addons-pack' );
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return __( 'When a user profile is updated', 'noptin-addons-pack' );
	}

}
