<?php

namespace Noptin\Addons_Pack\Custom_Fields\Triggers;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Handles all custom field related triggers.
 *
 * @since 2.0.0
 */
abstract class Abstract_Trigger extends \Noptin_Abstract_Trigger {

	/**
     * Whether or not this trigger deals with a subscriber.
     *
     * @var bool
     */
    public $is_subscriber_based = true;

	/**
	 * @var string
	 */
	public $is_multiple = false;

	/**
	 * @var string
	 */
	public $label;

	/**
	 * @var string
	 */
	public $merge_tag;

	/**
	 * Constructor.
	 *
	 * @since 1.9.0
	 * @return string
	 */
	public function __construct( $merge_tag, $label ) {
		$this->category  = $this->is_multiple ? $label : __( 'Custom Fields', 'noptin-addons-pack' );
		$this->label     = $label;
		$this->merge_tag = $merge_tag;

		$this->attach_hooks();
	}

	/**
	 * Attach relevant hooks.
	 */
	abstract public function attach_hooks();

	/**
	 * @inheritdoc
	 */
	public function get_image() {
		return array(
			'icon' => $this->is_multiple ? 'category' : 'editor-table',
			'fill' => '#0073aa',
		);
	}

	/**
     * Returns an array of known field options.
     *
     * @since 2.0.0
     * @return array
     */
    public function get_options() {
		$custom_field = get_noptin_subscriber_smart_tag( $this->merge_tag );
		return empty( $custom_field['options'] ) ? array() : noptin_newslines_to_array( $custom_field['options'] );
	}

	/**
     * Triggers when a field value is set.
     *
     * @since 2.0.0
     */
    public function trigger_set( $subscriber, $value ) {
		$options = $this->get_options();
		$label   = $value;

		if ( is_scalar( $value ) && isset( $options[ $value ] ) ) {
			$label = $options[ $value ];
		}

		$this->trigger(
			$subscriber,
			array(
				'field_value' => $value,
				'field_name'  => $label,
			)
		);
	}

	/**
     * Triggers when a field value changes.
     *
     * @since 2.0.0
     */
    public function trigger_changed( $subscriber, $from, $to ) {
		$this->trigger(
			$subscriber,
			array(
				'old_value' => $from,
				'new_value' => $to,
			)
		);
	}

}
