<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="row">
    <p class="text-large col-left mt-0"><?php esc_html_e( 'You are currently using WooCommerce Store Exporter Deluxe.', 'woocommerce-exporter' ); ?></p>
    <p class="license-status text-large col-right mt-0">
        <span class="label text-bold"><?php esc_html_e( 'License Status: ', 'woocommerce-exporter' ); ?></span>
        <span class="value <?php echo esc_attr( $wcsed_license_status_class_name ); ?>"><?php echo wp_kses_post( $wcsed_license_status_i18n ); ?></span>
    </p>
</div>
<p class="text-large mt-0 mb-1">
    <span class="text-bold"><?php esc_html_e( 'Version: ', 'woocommerce-exporter' ); ?></span>
    <span><?php echo esc_html( WOO_CD_VERSION ); ?></span>
</p>
<hr class="mb-2" />
<div class="row">
    <div class="col">
        <form class='form-row form-group' id="wcsed-license-form">
            <input type="hidden" id="wcsed_activate_license_nonce" name="wcsed_activate_license_nonce" value="<?php echo esc_attr( wp_create_nonce( 'wcsed_activate_license_nonce' ) ); ?>" />
            <div class="input-field input-field-left">
                <label for='license_key'><?php esc_html_e( 'License Key:', 'woocommerce-exporter' ); ?></label>
                <input type='password' class='form-control' id='license_key' name='license_key' placeholder="<?php esc_attr_e( 'License key', 'woocommerce-exporter' ); ?>" value="<?php echo esc_attr( $wcsed_license_key ); ?>" />
            </div>
            <div class="input-field input-field-right">
                <label for='activation_email'><?php esc_html_e( 'Activation Email:', 'woocommerce-exporter' ); ?></label>
                <input type='text' class='form-control' id='activation_email' name='activation_email' placeholder="<?php esc_attr_e( 'Activation email', 'woocommerce-exporter' ); ?>" value="<?php echo esc_attr( $wcsed_activation_email ); ?>" />
            </div>
            <div class="input-field input-button">
                <button type='submit' class='button button-primary' id='activate_license'><?php esc_html_e( 'Activate', 'woocommerce-exporter' ); ?></button>
                <span class="spinner"></span>
            </div>
        </form>
        <p>
            <?php
                printf(
                    // translators: %s is the link to the account page.
                    esc_html__( 'Can’t find your license key? %s', 'woocommerce-exporter' ),
                    '<a href="https://visser.com.au/my-account/?utm_source=wsed&utm_medium=license&utm_campaign=loginmyaccountlink" target="_blank">' . esc_html__( 'Login to your account', 'woocommerce-exporter' ) . '</a>'
                );
            ?>
        </p>
    </div>
</div>