<?php

namespace Noptin\Addons_Pack\Users\Triggers;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Fired when a WordPress user's role is removed.
 *
 * @since 1.9.0
 */
class Remove_User_Role extends Add_User_Role {

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'remove_user_role';
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return __( 'User > Remove Role', 'noptin-addons-pack' );
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return __( 'When a role is removed from a user', 'noptin-addons-pack' );
	}

}
